## Introduction to Security Intelligence

- Functions as the first line of defense against malicious traffic.
- Uses reputation intelligence to block connections, reducing the need for resource-intensive analysis.
- Generates special events called security intelligence events when a connection matches a blocked object.

## Security Intelligence Processing

- Matches traffic against Do Not Block and Block lists.
- Filtering occurs before any other policy-based inspection, except for traffic blocked or fastpathed in prefilter policies.
- For URLs/DNS, SSL decryption is performed first, as requested URLs may be encrypted.

## Security Intelligence Lists

### Categories

- **Block List**:
    
    - Contains traffic considered malicious.
    - Matches are blocked or monitored; blocked traffic undergoes no further inspection.
- **Do Not Block List**:
    
    - Overrides objects mistakenly appearing in the Block list.
    - Matches do not generate events; traffic continues processing.

### Objects Used in Lists

- **Feed Objects**:
    
    - Automatically updated lists provided by Cisco or third-party services.
    - Contain IP addresses/URLs with bad reputations.
- **List Objects**:
    
    - Manually created text files with static lists of IP addresses/URLs.
    - Uploaded to Cisco FMC; updates don't require policy deployment.
- **General Network/URL Objects**:
    
    - Static objects/groups created in Management Center; usable in other policies.
- **Global Do Not Block/Block Lists**:
    
    - Initially empty; populated from connection events.

### DNS Policy

- Performs DNS traffic filtering based on requested DNS names.
- Uses approved and blocked list categories similar to IP/URL lists.

## Use Cases and Characteristics

- **List Objects**: Upload static lists; updates don't require deployment.
- **Feed Objects**: Automatic updates; provided by Cisco Talos.
- **Global Lists**: Allow immediate blocking/allowing actions without deployment.

## Security Intelligence Use Case

- Block communication with known bad IPs/URLs using Cisco-provided feeds.
- Monitor suspicious IP addresses without blocking.
- Ensure partner server URLs are never blocked by using Do Not Block lists.

## Security Intelligence Events

- Contain data about connections matching a Block list object.
- Similar to connection events but include specific security intelligence details like matched categories.